#***************************************************************************************************
#                              R script for visualising TopoART networks                           *
#***************************************************************************************************
#                           Created by Marko Tscherepanow, 30 December 2012                        *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowTopoARTResults.R")

# Set to TRUE if you want to show the results of TopoART_sample3
# If FALSE, the results of TopoART_sample2 are shown
TopoART_sample3 <- FALSE

sapply(list.files(pattern = "[.]R$", path = "functions/", full.names = TRUE), source)

InitLibTopoARTScripts()

suffix <- ifelse(TopoART_sample3, "_large_and_noisy", "")

# Open TopoART network saved as a text file (Choose one of the two lines below!)
# ta <- new("TopoART", path = paste("../../results/networks/TopoART_AIL12-like_dataset", suffix, ".txt", sep = ""))
ta <- new("TopoART", path = paste("../../results/networks/Fast_TopoART_AIL12-like_dataset", suffix, ".txt", sep = ""))

# Images are saved to images/TA_x.pdf, where x denotes the module (a, b, c, d, or e).
SaveNetworkPlot(ta)
