#***************************************************************************************************
#                 R script for visualising regression results of TopoART-R networks                *
#***************************************************************************************************
#                            Created by Marko Tscherepanow, 12 June 2016                           *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowTopoARTRResults.R")

# Open regression results
data <- read.csv("../../results/regression/TopoART-R_sine_regression_results.csv", FALSE)

# Read data
trainingSampleNum	<-	data[1, 1]
testSampleNum		<-	data[1, 2]
trainingSamples		<-	data[2 : (trainingSampleNum + 1), ]
testSamples			<-	data[(trainingSampleNum + 2) : (trainingSampleNum + testSampleNum + 1), ]

# Images are saved to images/TAR_regression.pdf
pdf(file = "images/TAR_regression.pdf", width = 7.7778, height = 6.1333)

par(cex.axis = 1.5, cex.lab = 1.5, cex.main = 1.6)
plot(trainingSamples[, 1], trainingSamples[, 2], xaxt = "n", xaxp = c(0, 2*pi, 8), xlim = c(0, 2 * pi), ylim = c(-1, 1), xlab = "x", ylab = "sin(x)", pch = ".", col = "blue")
points(testSamples[, 1], testSamples[, 2], col = "red")
xticks <- seq(0, 2 * pi, by = pi / 4)
abline(h = seq(-1, 1, by = 0.25), lty = 3, col = "grey")
abline(v = xticks, lty = 3, col = "grey")
axis(side = 1, at = xticks, labels = c("0", expression(pi/4), expression(pi/2), expression(3*pi/4), expression(pi), expression(5*pi/4), expression(3*pi/2), expression(7*pi/4), expression(2*pi)))

title(main = bquote("TopoART-R:"~"regression results"), font.main = 2)
legend(4.68, 1, c("training", "prediction"), pch = c(46, 1), col = c("blue", "red"), cex = 1.5, bg = "white");
dev.off()
