#***************************************************************************************************
#                             R script for visualising TopoART-C networks                          *
#***************************************************************************************************
#                            Created by Marko Tscherepanow, 19 April 2017                          *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowTopoARTCResults.R")

sapply(list.files(pattern = "[.]R$", path = "functions/", full.names = TRUE), source)

InitLibTopoARTScripts()

# Open TopoART-C network saved as a text file (Choose one of the two lines below!)
# tac <- new("TopoARTC", path = "../../results/networks/TopoART-C_AIL12-like_dataset.txt")
tac <- new("TopoARTC", path = "../../results/networks/Fast_TopoART-C_AIL12-like_dataset.txt")

# Images are saved to images/TAC_x.pdf and images/TAC_x_class_IDs.pdf, where x denotes the module (a, b, c, d, or e).
# In comparison to TopoART, the clusters are split at class boundaries. This becomes visible by comparing
# images/TAC_x.pdf and images/TAC_x_class_IDs.pdf with their respective counterpart images/TA_x.pdf computed by
# ShowTopoARTResults.R from a TopoART network trained with the same dataset. Additionally, clusters may be randomly
# split due to the random class IDs that were assigned to noise samples. 
SaveNetworkPlot(tac)
