#***************************************************************************************************
#                            R script for visualising TopoART-AM networks                          *
#***************************************************************************************************
#                            Created by Marko Tscherepanow, 10 March 2019                          *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowTopoARTAMResults.R")

sapply(list.files(pattern = "[.]R$", path = "functions/", full.names = TRUE), source)

InitLibTopoARTScripts()

# Open TopoART-AM network saved as a text file
tam <- new("TopoARTAM", path = "../../results/networks/Fast_TopoART-AM_TwoSpirals_dataset.txt")

# Visualise network weights associated with key 1
# Images are saved to images/TAM_x_key1.pdf, where x denotes the module (a, b, c, d, or e).
SaveNetworkPlotKey1(tam)

# Visualise network weights associated with key 2
# Images are saved to images/TAM_x_key2.pdf, where x denotes the module (a, b, c, d, or e).
SaveNetworkPlotKey2(tam)
