#***************************************************************************************************
#                        R script for visualising Hypersphere TopoART networks                     *
#***************************************************************************************************
#                           Created by Marko Tscherepanow, 21 September 2014                       *
#***************************************************************************************************
# Requires R package "plotrix" to be installed                                                     *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowHypersphereTopoARTResults.R")

# Set to TRUE if you want to show the results of TopoART_sample3
# If FALSE, the results of TopoART_sample2 are shown
TopoART_sample3 <- FALSE

# Load R package "plotrix"
# If not available, it may be installed with 'install.packages("plotrix")'
library(plotrix)

sapply(list.files(pattern = "[.]R$", path = "functions/", full.names = TRUE), source)

InitLibTopoARTScripts()

suffix <- ifelse(TopoART_sample3, "_large_and_noisy", "")

# Open Hypersphere TopoART network saved as a text file
hta <- new("HypersphereTopoART", path = paste("../../results/networks/Hypersphere_TopoART_AIL12-like_dataset", suffix, ".txt", sep = ""))

# Images are saved to images/HTA_x.pdf, where x denotes the module (a, b, c, d, or e).
SaveNetworkPlot(hta)
