#***************************************************************************************************
#                       R script for visualising Hypersphere TopoART-C networks                    *
#***************************************************************************************************
#                            Created by Marko Tscherepanow, 1 January 2018                         *
#***************************************************************************************************
# Requires R package "plotrix" to be installed                                                     *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowHypersphereTopoARTCResults.R")

# Load R package "plotrix"
# If not available, it may be installed with 'install.packages("plotrix")'
library(plotrix)

sapply(list.files(pattern = "[.]R$", path = "functions/", full.names = TRUE), source)

InitLibTopoARTScripts()

# Open Hypersphere TopoART-C network saved as a text file
htac <- new("HypersphereTopoARTC", path = "../../results/networks/Hypersphere_TopoART-C_AIL12-like_dataset.txt")

# Images are saved to images/HTAC_x.pdf and images/HTAC_x_class_IDs.pdf, where x denotes the module (a, b, c, d, or e).
# In comparison to Hypersphere TopoART, the clusters are split at class boundaries. This becomes visible by comparing
# images/HTAC_x.pdf and images/HTAC_x_class_IDs.pdf with their respective counterpart images/HTA_x.pdf computed by
# ShowHypersphereTopoARTResults.R from a Hypersphere TopoART network trained with the same dataset. Additionally, clusters
# may be randomly split due to the random class IDs that were assigned to noise samples. 
SaveNetworkPlot(htac)
