#***************************************************************************************************
#              R script for visualising the recall results of Episodic TopoART networks            *
#***************************************************************************************************
#                             Created by Marko Tscherepanow, 28 May 2016                           *
#***************************************************************************************************
# Requires R package "jpeg" to be installed                                                        *
#***************************************************************************************************

# Set the working directory to <LibTopoART directory>/visualisation/R/
# Run: source("ShowEpisodicTopoARTRecallResults.R")

# Load R package "jpeg"
# If not available, it may be installed with 'install.packages("jpeg")'
library(jpeg)

sapply(list.files(pattern = "[.]R$", path = "functions/", full.names = TRUE), source)

InitLibTopoARTScripts()

# Open recall results
rv <- new("EpisodicTopoARTRecallViewer", path = "../../results/recall/AIL12-like_video_dataset_recall_results/")

# Images are saved to images/ETA_recall.pdf .
SaveRecallPlot(rv, 5, 25)
