classdef TopoARTNode < handle
    properties
        nodeID {mustBeInteger, mustBeNonnegative}
        clusterID {mustBeInteger}
        inputLen {mustBeInteger, mustBePositive}
        representedInputs {mustBeInteger, mustBePositive}
        activation {mustBeNumeric}
        matchValue {mustBeNumeric}
        edgeNum {mustBeInteger, mustBeNonnegative}
        edgeTargets
        weights
    end

    methods (Access = protected)
        function ReadAdditionalData1(node, file)
            arguments
                node TopoARTNode
                file
            end
        end

        function ReadAdditionalData2(node, file)
            arguments
                node TopoARTNode
                file
            end
        end
    end

    methods
        function n = TopoARTNode(file, index)
            arguments
                file
                index {mustBeInteger, mustBePositive}
            end

            fgetl(file);
            l = fgetl(file);
            n.nodeID = sscanf(l, 'node ID: %i');
            l = fgetl(file);
            n.clusterID = sscanf(l, 'cluster ID: %i');
            l = fgetl(file);
            n.inputLen = sscanf(l, 'input length: %i');
            l = fgetl(file);
            n.representedInputs = sscanf(l, 'represented inputs: %i');
            l = fgetl(file);
            n.activation = sscanf(l, 'activation: %f');
            l = fgetl(file);
            n.matchValue = sscanf(l, 'match value: %f');

            n.ReadAdditionalData1(file);

            fgetl(file);
            l = fgetl(file);
            n.edgeNum = sscanf(l, 'edge number: %i');
            l = fgetl(file);
            n.edgeTargets = sscanf(l(15:length(l)), ' %f', n.edgeNum);

            fgetl(file);
            l = fgetl(file);
            n.weights = sscanf(l, '%f', n.inputLen);

            n.ReadAdditionalData2(file)
        end
    end
end