classdef TopoARTModule < handle
    properties
        x_F1_len {mustBeInteger, mustBePositive}
        x_F1
        rho	{mustBeNumeric}
        nextID {mustBeInteger, mustBeNonnegative}
        validClusterIDs {mustBeNumericOrLogical, mustBeNonnegative}
        clusterNum {mustBeInteger, mustBeNonnegative}
        learningCycles {mustBeInteger, mustBeNonnegative}
        nodeNum	{mustBeInteger, mustBeNonnegative}
        nodes
    end

    methods (Access = protected)
        function ReadAdditionalParams(m, file)
            arguments
                m TopoARTModule
                file
            end
        end

        function ReadNodes(m, file)
            arguments
                m TopoARTModule
                file
            end

            for i = 1:m.nodeNum
                readNodes(i) = TopoARTNode(file, i);
            end
            m.nodes = readNodes;
        end
    end

    methods
        function m = TopoARTModule(file, index, networkName)
            arguments
                file
                index {mustBeInteger, mustBePositive}
                networkName
            end

            letters = 'a':'z';
            disp(['Load ' networkName ' module ' letters(index)])

            fgetl(file);
            fgetl(file);
            fgetl(file);

            m.ReadAdditionalParams(file)

            l = fgetl(file);
            m.x_F1_len = sscanf(l, 'x^F1 length: %i');

            l = fgetl(file);
            m.x_F1 = sscanf(l(6:length(l)), ' %f', m.x_F1_len);

            l = fgetl(file);
            m.rho = sscanf(l, 'rho: %f');
            l = fgetl(file);
            m.nextID = sscanf(l, 'next ID: %i');
            l = fgetl(file);
            tmpString = sscanf(l, 'valid cluster IDs: %s');
            m.validClusterIDs = ifelse(strcmp(tmpString, 'true') == 1, true, false);
            l = fgetl(file);
            m.clusterNum = sscanf(l, 'cluster number: %i');
            l = fgetl(file);
            m.learningCycles = sscanf(l, 'learning cycles: %i');

            l = fgetl(file);
            m.nodeNum = sscanf(l, 'node number: %i');
            m.ReadNodes(file)
        end
    end
end
