classdef TopoARTCModule < TopoARTModule
    properties
        minClassID {mustBeInteger}
        maxClassID {mustBeInteger}
    end

    methods (Access = protected)
        function ReadNodes(m, file)
            arguments
                m TopoARTCModule
                file
            end

            m.minClassID = intmax('int64');
            m.maxClassID = intmin('int64');

            for i = 1:m.nodeNum
                readNodes(i) = TopoARTCNode(file, i);
                m.minClassID = min(readNodes(i).classID, m.minClassID);
                m.maxClassID = max(readNodes(i).classID, m.maxClassID);
            end
            m.nodes = readNodes;
        end
    end
end