classdef TopoARTAM < TopoART
    properties
        fileFormatVersion {mustBeNumeric}
        key1Len {mustBeInteger, mustBePositive}
        key2Len {mustBeInteger, mustBePositive}
    end

    methods (Access = protected)
        function [off1, off2] = GetWeightsOffsets(tam)
            arguments
                tam TopoARTAM
            end
            
            off1 = tam.key1Len;
            off2 = tam.key2Len;
        end

        function Init(tam)
            tam.shortName = 'TAM';
            tam.longName = 'TopoART-AM';
        end

        function file = OpenFile(tam, path)
            arguments
                tam TopoARTAM
                path char {mustBeFile}
            end

            disp(['Load ' tam.longName ' network: ' path])

            file = fopen(path,'r');
            assert(file ~= -1, 'File not found')

            fgetl(file);
            l = fgetl(file);
            assert(strcmp(l, '*      TopoART-AM network       *') ~= 0, 'No TopoART-AM text file')    
            l = fgetl(file);
            tam.LibTopoART_version = sscanf(l(8:length(l)),'LibTopoART (v%f)');
            fprintf("LibTopoART v%.2f\n", tam.LibTopoART_version);
            fgetl(file);

            l = fgetl(file);
            fileFormatVersions = sscanf(l,'file format versions: %f; %f');
            tam.fileFormatVersion = fileFormatVersions(1);
            tam.taFileFormatVersion = fileFormatVersions(2);
            assert((tam.fileFormatVersion == 0.01 && (tam.taFileFormatVersion == 0.10 || ...
                tam.taFileFormatVersion == 0.11 || tam.taFileFormatVersion == 1.00)) || ...
                (tam.fileFormatVersion == 1.00 && tam.taFileFormatVersion == 1.00), ...
                'File format version not supported')
        end

        function ReadAdditionalParams(tam, file)
            arguments
                tam TopoARTAM
                file
            end

            if tam.fileFormatVersion >= 1.00
                keyString = 'key ';
            else
                keyString = 'key_';
            end

            l = fgetl(file);
            tam.key1Len = sscanf(l, [keyString '1 length: %i']);
            l = fgetl(file);
            tam.key2Len = sscanf(l, [keyString '2 length: %i']);
            fgetl(file);
        end
    end

    methods
        function PlotNetworkKey1(tam, colors)
            arguments
                tam TopoARTAM
                colors
            end

            for m = 1:tam.moduleNum
                tam.PlotModule(m, colors, 0, tam.key2Len, ' (key 1)', '', '_key1')
            end
        end

        function PlotNetworkKey2(tam, colors)
            arguments
                tam TopoARTAM
                colors
            end

            for m = 1:tam.moduleNum
                tam.PlotModule(m, colors, tam.key1Len, 0, ' (key 2)', '', '_key2')
            end
        end
    end
end