classdef EpisodicTopoARTNode < TopoARTNode
    properties
        temporalMatchValue {mustBeNumeric}
        combinedMatchValue {mustBeNumeric}
        temporalWeights
    end

    methods (Access = protected)
        function ReadAdditionalData2(node, file)
            arguments
                node EpisodicTopoARTNode
                file
            end

            fgetl(file);
            l = fgetl(file);
            node.temporalMatchValue = sscanf(l, 'temporal match value: %f');
            l = fgetl(file);
            node.combinedMatchValue = sscanf(l, 'combined match value: %f');

            fgetl(file);
            l = fgetl(file);
            node.temporalWeights = sscanf(l, '%f', 2);
        end
    end
end