classdef EpisodicTopoARTModule < TopoARTModule
    properties
        t_F1
    end

    methods (Access = protected)
        function ReadAdditionalParams(m, file)
            arguments
                m EpisodicTopoARTModule
                file
            end

            l = fgetl(file);
            m.t_F1 = sscanf(l(6:length(l)), ' %f', 2);
        end

        function ReadNodes(m, file)
            arguments
                m EpisodicTopoARTModule
                file
            end

            for i = 1:m.nodeNum
                readNodes(i) = EpisodicTopoARTNode(file, i);
            end
            m.nodes = readNodes;
        end
    end
end