%***************************************************************************************************
%                           MATLAB script for visualising TopoART networks                         *
%***************************************************************************************************
%                             Created by Marko Tscherepanow, 16 May 2021                           *
%***************************************************************************************************

% Add <LibTopoART directory>/visualisation/MATLAB/ to the MATLAB search path

% Set to true if you want to show the results of TopoART_sample3
% If false, the results of TopoART_sample2 are shown
TopoART_sample3 = false;

basePath = fileparts(mfilename('fullpath'));
addpath([basePath '/functions/'])

suffix = ifelse(TopoART_sample3, '_large_and_noisy', '');

% Open TopoART network saved as a text file (Choose one of the two lines below!)
% ta = TopoART([basePath '/../../results/networks/TopoART_AIL12-like_dataset' suffix '.txt']);
ta = TopoART([basePath '/../../results/networks/Fast_TopoART_AIL12-like_dataset' suffix '.txt']);

% Plot network weights and save them to images/TA_x.pdf, where x denotes the module (a, b, c, d, e, ...)
ta.PlotNetwork(hsv)