%***************************************************************************************************
%              MATLAB script for visualising regression results of TopoART-R networks              *
%***************************************************************************************************
%                            Created by Marko Tscherepanow, 10 June 2021                           *
%***************************************************************************************************

% Add <LibTopoART directory>/visualisation/MATLAB/ to the MATLAB search path

% Open regression results
data = load('../../results/regression/TopoART-R_sine_regression_results.csv');

% Read data
trainingSampleNum	=	data(1, 1);
testSampleNum		=	data(1, 2);
trainingSamples		=	data(2 : (trainingSampleNum + 1), :);
testSamples			=	data((trainingSampleNum + 2) : (trainingSampleNum + testSampleNum + 1), :);

f = figure('Name', 'TopoART-R: regression results');
hold on;

axis([0 2*pi -1 1]);
set(gca, 'FontSize', 12.0);
set(gca, 'XTick', 0:pi/4:2*pi);
set(gca,'XTickLabel', {0, '\pi/4', '\pi/2', '3\pi/4', '\pi', '5\pi/4', '3\pi/2', '7\pi/4', '2\pi'});
xlabel('x');
set(gca, 'YTick', -1:0.25:1);
set(gca,'YTickLabel', {-1, [], -0.5, [], 0, [], 0.5, [], 1});
ylabel('sin(x)');
title('TopoART-R: regression results', 'FontSize', 13.3, 'Interpreter', 'Latex', 'Position', [pi 1.03 0]);
grid on;

plot(trainingSamples(:, 1), trainingSamples(:, 2),'b.');
plot(testSamples(:, 1), testSamples(:, 2),'ro');
legend('training','prediction','Location', 'NorthEast')

basePath = fileparts(mfilename('fullpath'));
f.Units = 'inches';
set(f, 'PaperPositionMode', 'auto', 'PaperUnits', 'inches', 'PaperSize', f.Position(3:4) + [0.0 0.3])

% Images are saved to images/TAR_regression.pdf
saveas(f, [basePath '/images/' 'TAR_regression.pdf']);