%***************************************************************************************************
%                         MATLAB script for visualising TopoART-C networks                         *
%***************************************************************************************************
%                            Created by Marko Tscherepanow, 30 May 2021                            *
%***************************************************************************************************

% Add <LibTopoART directory>/visualisation/MATLAB/ to the MATLAB search path

basePath = fileparts(mfilename('fullpath'));
addpath([basePath '/functions/'])

% Open TopoART-C network saved as a text file (Choose one of the two lines below!)
% tac = TopoARTC([basePath '/../../results/networks/TopoART-C_AIL12-like_dataset.txt']);
tac = TopoARTC([basePath '/../../results/networks/Fast_TopoART-C_AIL12-like_dataset.txt']);

% Images are saved to images/TAC_x.pdf and images/TAC_x_class_IDs.pdf, where x denotes the module (a, b, c, d, e, ...).
% In comparison to TopoART, the clusters are split at class boundaries. This becomes visible by comparing
% images/TAC_x.pdf and images/TAC_x_class_IDs.pdf with their respective counterpart images/TA_x.pdf computed by
% ShowTopoARTResults.m from a TopoART network trained with the same dataset. Additionally, clusters may be randomly 
% split due to the random class IDs that were assigned to noise samples. 
tac.PlotNetwork(hsv)