%***************************************************************************************************
%                   MATLAB script for visualising Hypersphere TopoART-C networks                   *
%***************************************************************************************************
%                            Created by Marko Tscherepanow, 6 June 2021                            *
%***************************************************************************************************

% Add <LibTopoART directory>/visualisation/MATLAB/ to the MATLAB search path

basePath = fileparts(mfilename('fullpath'));
addpath([basePath '/functions/'])

% Open TopoART-AM network saved as a text file
tam = TopoARTAM([basePath '/../../results/networks/Fast_TopoART-AM_TwoSpirals_dataset.txt']);

% Visualise network weights associated with key 1
% Images are saved to images/TAM_x_key1.pdf, where x denotes the module (a, b, c, d, e, ...).
tam.PlotNetworkKey1(summer)

% Visualise network weights associated with key 2
% Images are saved to images/TAM_x_key2.pdf, where x denotes the module (a, b, c, d, e, ...).
tam.PlotNetworkKey2(summer)
