%***************************************************************************************************
%                     MATLAB script for visualising HypersphereTopoART networks                    *
%***************************************************************************************************
%                             Created by Marko Tscherepanow, 23 May 2021                           *
%***************************************************************************************************

% Add <LibTopoART directory>/visualisation/MATLAB/ to the MATLAB search path

% Set to true if you want to show the results of TopoART_sample3
% If false, the results of TopoART_sample2 are shown
TopoART_sample3 = false;

basePath = fileparts(mfilename('fullpath'));
addpath([basePath, '/functions/'])

suffix = ifelse(TopoART_sample3, '_large_and_noisy', '');

% Open Hypersphere TopoART network saved as a text file
hta = HypersphereTopoART([basePath '/../../results/networks/Hypersphere_TopoART_AIL12-like_dataset' suffix '.txt']);

% Plot network weights and save them to images/HTA_x.pdf, where x denotes the module (a, b, c, d, e, ...).

hta.PlotNetwork(hsv)