%***************************************************************************************************
%                   MATLAB script for visualising Hypersphere TopoART-C networks                   *
%***************************************************************************************************
%                            Created by Marko Tscherepanow, 5 June 2021                            *
%***************************************************************************************************

% Add <LibTopoART directory>/visualisation/MATLAB/ to the MATLAB search path

basePath = fileparts(mfilename('fullpath'));
addpath([basePath '/functions/'])

% Open Hypersphere TopoART-C network saved as a text file
htac = HypersphereTopoARTC([basePath '/../../results/networks/Hypersphere_TopoART-C_AIL12-like_dataset.txt']);

% Images are saved to images/HTAC_x.pdf and images/HTAC_x_class_IDs.pdf, where x denotes the module (a, b, c, d, e, ...).
% In comparison to Hypersphere TopoART, the clusters are split at class boundaries. This becomes visible by comparing
% images/HTAC_x.pdf and images/HTAC_x_class_IDs.pdf with their respective counterpart images/HTA_x.pdf computed by
% ShowHypersphereTopoARTResults.m from a Hypersphere TopoART network trained with the same dataset. Additionally, clusters 
% may be randomly split due to the random class IDs that were assigned to noise samples. 
htac.PlotNetwork(hsv)